/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.juddi.datatype.Name;

public class VWUDDIBrowseTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon m_uddiMainIcon = VWImageLoader.createImageIcon("uddiMain.gif");
    private ImageIcon m_uddiRegistryIcon = VWImageLoader.createImageIcon("uddiRegistry.gif");
    private ImageIcon m_uddiRegistryUnknownIcon = VWImageLoader.createImageIcon("uddiRegistryUnknown.gif");
    private ImageIcon m_uddiRegistryUnreachableIcon = VWImageLoader.createImageIcon("uddiRegistryBad.gif");
    private ImageIcon m_businessListIcon = VWImageLoader.createImageIcon("uddiBusinessList.gif");
    private ImageIcon m_businessEntityIcon = VWImageLoader.createImageIcon("uddiBusinessDetails.gif");
    private ImageIcon m_modifiedBusinessEntityIcon = VWImageLoader.createImageIcon("modifiedBusinessEntity.gif");
    private ImageIcon m_invalidBusinessEntityIcon = VWImageLoader.createImageIcon("invalidBusinessEntity.gif");
    private ImageIcon m_businessServiceIcon = VWImageLoader.createImageIcon("uddiBusinessService.gif");
    private ImageIcon m_tModelIcon = VWImageLoader.createImageIcon("uddiTModel.gif");
    private ImageIcon m_tModelListIcon = VWImageLoader.createImageIcon("uddiTModelList.gif");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value != null) {
            Object nodeInfo = null;
            String text = null;
            if (value instanceof DefaultMutableTreeNode) {
                nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
            }
            if (nodeInfo != null) {
                if (nodeInfo instanceof VWUDDIRegistryItem[]) {
                    this.setIcon(this.m_uddiMainIcon);
                    text = VWResource.s_uddiBusinessRegistries;
                    this.setToolTipText(text);
                }
                if (nodeInfo instanceof VWUDDIRegistryItem) {
                    int registryState = ((VWUDDIRegistryItem)nodeInfo).getState();
                    if (registryState == 1) {
                        this.setIcon(this.m_uddiRegistryIcon);
                        this.setToolTipText(VWResource.s_registryStateConnected);
                    } else if (registryState == 2) {
                        this.setIcon(this.m_uddiRegistryUnreachableIcon);
                        this.setToolTipText(VWResource.s_registryStateUnreachable);
                    } else {
                        this.setIcon(this.m_uddiRegistryUnknownIcon);
                        this.setToolTipText(VWResource.s_registryStateUnknown);
                    }
                    text = ((VWUDDIRegistryItem)nodeInfo).toString();
                } else if (nodeInfo instanceof VWUDDIBusinessEntity) {
                    this.setIcon(this.m_businessEntityIcon);
                    text = ((VWUDDIBusinessEntity)nodeInfo).getNameString(0);
                    this.setToolTipText(text);
                } else if (nodeInfo instanceof VWUDDIBusinessItem) {
                    VWUDDIBusinessItem businessItem = (VWUDDIBusinessItem)nodeInfo;
                    Name name = businessItem.getName(0);
                    text = null;
                    if (name != null) {
                        text = name.getValue();
                    }
                    if (!businessItem.isValid()) {
                        this.setIcon(this.m_invalidBusinessEntityIcon);
                        this.setToolTipText(text);
                    } else if (((VWUDDIBusinessItem)nodeInfo).isModified()) {
                        this.setIcon(this.m_modifiedBusinessEntityIcon);
                        this.setToolTipText(text);
                    } else {
                        this.setIcon(this.m_businessEntityIcon);
                    }
                } else if (nodeInfo instanceof WSBusinessService) {
                    this.setIcon(this.m_businessServiceIcon);
                    text = ((WSBusinessService)nodeInfo).getName();
                    this.setToolTipText(text);
                } else if (nodeInfo instanceof WSTModel) {
                    this.setIcon(this.m_tModelIcon);
                    text = ((WSTModel)nodeInfo).getName();
                    this.setToolTipText(text);
                }
                this.setText(text);
            }
            return this;
        }
        return comp;
    }
}

